import os
os.environ["OMP_NUM_THREADS"] = "12"
os.environ["MKL_NUM_THREADS"] = "12"
os.environ["NUMEXPR_NUM_THREADS"] = "12"
import sys
sys.path.append(r'../Refer_Judge')   # Change this
import json
from image_find_target_frames import iteration_pos
from image_find_misleading_frames import iteration_mis
from jury_and_judge.config import org_data, process_json_path, ScanNet_ROOT

data_id = 0
for item in org_data:
    item.update({'item_id': data_id})
    scene_id = item['scene_id']
    scannet_root = ScanNet_ROOT.format(scene_id, scene_id)
    with open(scannet_root) as f:
        scannet_info = json.load(f)
    object_id = item['object_id']
    object_name = scannet_info['segGroups'][int(object_id)]['label']

    scannet_object_info = scannet_info['segGroups']
    match_number = 0
    for info in scannet_object_info:
        if info['label'] == object_name:
            match_number += 1
    item.update({'same_obj_in_scene': match_number})

    data_id += 1


data_with_pos_frames = iteration_pos(org_data)
data_with_mis_frames = iteration_mis(data_with_pos_frames)

with open(process_json_path, 'w') as f:
    json.dump(data_with_mis_frames, f)